require 'rspec'

require_relative '../../module/DriverUtility'
require_relative '../rspec_helper'
require_relative '../../pages/varUtility/landing'
require_relative '../../helper/modal'
require_relative '../../common/accessVarUtility'
require_relative '../../common/common'
require_relative '../../pages/varUtility/manage_settings'
require_relative '../../module/DateUtility'
require_relative '../../helper/table'
require_relative '../../pages/varUtility/error_validation'
require_relative '../../pages/varUtility/manage_settings/request_settings'
require_relative '../../module/database/MongoUtility'
require_relative '../../pages/vaToolSet/home'
require_relative '../../pages/landing_page'
require 'vaToolSet/vaToolSet_pageObject'
require_relative '../../common/accessVarUtility'


describe '[Story#VARUT-937: Request Settings: Custom Requests Configuration]' do
  include DriverUtility
  include DateUtility
  include MongoUtility

  before(:all) do
    initializeConfigurations(BASE_URL)
    @db = connectToVarMongoDB("var-utility")
    @landing = Landing.new(@driver)
    @login = Login.new(@driver)
    @common = Common.new(@driver)
    @base = Base.new(@driver)
    @request_setting = Request_Settings.new(@driver)
    @manage_setting = Manage_Settings.new(@driver)
    @table = Table.new(@driver)
    @error = Error_Validation.new(@driver)
    @modal = Modal.new(@driver)
    @loginUtil = AccessVarUtility.new(@driver)
    @home = Home.new(@driver)
    @landing_page = LandingPage.new(@driver)
    @vts_po  = VaToolSet_PageObject.new(@driver)
  end

  after(:all) do
    @driver.close
  end
  #Reset Data in Mongo DB
  it "Remove Mongo" do
    restoreCollection("clinical-services", "var-utility", "clinical_services_default.json", @db)
    removeCollection("requestEligibilityCriteria", @db)
  end

  context 'AC#VARUT-1239|TC#VARUT-1240: Validate Request Settings: Custom Requests Configuration' do
    it "Login and Navigate to Request" do
      @loginUtil.access_var_utility(UserAccess7)
      @landing.rightFooter_element.when_visible(TIME_OUT_LIMIT)
      Watir::Wait.until {@landing.rightFooter == "Logged in as PROVIDER, SEVEN"}
      expect(@landing.rightFooter).to eq("Logged in as PROVIDER, SEVEN")

      @landing_page.facility_location_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_page.facility_location_element.select_value('BOSTON HCS VAMC')
      @landing_page.view_settings_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_page.view_settings

      @landing.home_btn_element.when_visible(TIME_OUT_LIMIT)
      @vts_po.landing.primary_header_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@vts_po.landing.primary_header).to eq("Welcome")

      @manage_setting.clickOption("Requests")
      #@common.waitWhileSpinnerPresent
      @common.wait_untill_elements_size_steadied
      expect(@landing.primary_header).to eq("Requests")
    end

    it "Request Setting Instructional text" do
      expect(@request_setting.request_settings_heading).to eq("BOSTON HCS VAMC Request Settings")
      expect(@request_setting.instructional_text).to eq("For the care types in the groupings listed below, provide the request settings supported by this location.")
    end

    it "Default Express Care Display - No (Default)" do
      @request_setting.expressCareNotSupported_element.when_visible(TIME_OUT_LIMIT)
      expect(@request_setting.customRequestHeading).to eq("Custom Requests")

      expected_content =[\
                        "Express Care",
                        "Supported at this location?",
                        "No Yes – With PACT Team Assignment",
                        "Reset"
      ]

      actual_content = @request_setting.expressCareSection.split("\n")

      compareContents(expected_content, actual_content)

      saveAndConfirm

      #Retrieve mongo

      schedulingDaysArr = [["MONDAY", "false", "", ""], ["TUESDAY", "false", "", ""], ["WEDNESDAY", "false", "", ""],["THURSDAY", "false", "", ""],["FRIDAY", "false", "", ""], ["SATURDAY", "false", "", ""], ["SUNDAY", "false", "", ""]]
      verifyExpresscareDatainMongoDB("523", "0", "false",  "Express Care", schedulingDaysArr)

    end

    it "the Enterprise does not support requests for the Express Care" do
    #update requestimit = 0 or null
      select_faciity = "BROCKTON VAMC"
    updateDocument("clinical-services", "CR1", "submittedRequestLimit", 0, @db)

    @driver.refresh
    @common.waitWhileSpinnerPresent
    @landing_page.facility_location_element.wait_until_present(TIME_OUT_LIMIT)
    @landing_page.facility_location_element.select_value(select_faciity)
    @landing_page.view_settings_element.wait_until_present(TIME_OUT_LIMIT)
    @landing_page.view_settings
    @landing_page.request_button_element.wait_until_present(TIME_OUT_LIMIT)

    @manage_setting.clickOption("Requests")
    #@common.waitWhileSpinnerPresent
    @common.wait_untill_elements_size_steadied
    expect(@landing.primary_header).to eq("Requests")

    @request_setting.expressCareNotSupported_element.when_visible(TIME_OUT_LIMIT)
    expect(@request_setting.customRequestHeading).to eq("Custom Requests")


    expected_content =[\
                        "Express Care",
                        "Supported at this location?",
                        "No Yes – With PACT Team Assignment",
                        "VA does not support request submission at this time.",
                        "Reset"
    ]

    actual_content = @request_setting.expressCareSection.split("\n")
    compareContents(expected_content, actual_content)

    expect(@request_setting.expressCareNotSupported_element.disabled?).to eq(true)
    expect(@request_setting.expressCareNotSupported_element.selected?).to eq(true)

    expect(@request_setting.expressCareSupported_element.disabled?).to eq(true)
    expect(@request_setting.expressCareSupported_element.selected?).to eq(false)

  end

      it "Yes – With PACT Team Assignment is selected" do
        select_faciity = "BROCKTON VAMC"
      updateDocument("clinical-services", "CR1", "submittedRequestLimit", 3, @db)

      @driver.refresh
      @common.wait_untill_elements_size_steadied
      @landing_page.facility_location_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_page.facility_location_element.select_value(select_faciity)
      @landing_page.view_settings_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_page.view_settings
      @landing_page.request_button_element.wait_until_present(TIME_OUT_LIMIT)

      @manage_setting.clickOption("Requests")
      #@common.waitWhileSpinnerPresent
      @common.wait_untill_elements_size_steadied
      expect(@landing.primary_header).to eq("Requests")
      @request_setting.expressCareNotSupported_element.when_visible(TIME_OUT_LIMIT)
      expect(@request_setting.customRequestHeading).to eq("Custom Requests")

      @request_setting.expressCareSupported_element.scroll_into_view
      @request_setting.expressCareSupported_element.click
      expect(@request_setting.expressCareSupported_element.selected?).to eq(true)

      @common.wait_untill_elements_size_steadied
      @request_setting.bottomSave_element.scroll_into_view

      expected_content =[\
                        "Express Care",
                        "Supported at this location?",
                        "No Yes – With PACT Team Assignment",
                        "Submitted Request Limit",
                        "Select",
                        "1",
                        "2",
                        "3",
                        "Staff Availability",
                        "When will staff be available to monitor and schedule incoming Express Care requests?",
                        "* Day",
                        "* Start Time",
                        "* End Time",
                        "Monday",
                        "Tuesday",
                        "Wednesday",
                        "Thursday",
                        "Friday",
                        "Saturday",
                        "Sunday",
                        "Reset"
      ]

      actual_content = @request_setting.expressCareSection.split("\n")
      compareContents(expected_content, actual_content)

      expect(@request_setting.expressCareSubmittedRequestLimit).to eq("3")
    end

    it "At least one day must be checked on Save;" do
      @request_setting.bottomSave

      @error.errorSummaryHeader_element.when_visible(TIME_OUT_LIMIT)
      expect(@error.isErrorMsgDisplayed?("At least one day must be selected to support an Express Care request.")).to eq(true)
      @request_setting.expressCareSubmittedRequestLimit = 2
    end

    it "Checkbox options listed with all days of the week, starting with Monday " do
      #days of week checkbox fields visible and enabled
      expect(@request_setting.monday_element.visible?).to eq(true)
      expect(@request_setting.tuesday_element.visible?).to eq(true)
      expect(@request_setting.wednesday_element.visible?).to eq(true)
      expect(@request_setting.thursday_element.visible?).to eq(true)
      expect(@request_setting.friday_element.visible?).to eq(true)
      expect(@request_setting.saturday_element.visible?).to eq(true)
      expect(@request_setting.sunday_element.visible?).to eq(true)

    end

    it "When a checkbox is selected the Start Time and End Time fields for the same row are displayed;  when the checkbox null the fields are hidden." do
      @request_setting.monday_element.click
      @request_setting.tuesday_element.click
      @request_setting.wednesday_element.click
      @request_setting.thursday_element.click
      @request_setting.friday_element.click
      @request_setting.saturday_element.click
      @request_setting.sunday_element.click

      #start time and end time displayed
      expect(@request_setting.mondayStartTime_element.visible?).to eq(true)
      expect(@request_setting.mondayEndTime_element.visible?).to eq(true)
      expect(@request_setting.tuesdayStartTime_element.visible?).to eq(true)
      expect(@request_setting.tuesdayEndTime_element.visible?).to eq(true)

      expect(@request_setting.wednesdayStartTime_element.visible?).to eq(true)
      expect(@request_setting.wednesdayEndTime_element.visible?).to eq(true)

      expect(@request_setting.thursdayStartTime_element.visible?).to eq(true)
      expect(@request_setting.thursdayEndTime_element.visible?).to eq(true)

      expect(@request_setting.fridayStartTime_element.visible?).to eq(true)
      expect(@request_setting.fridayEndTime_element.visible?).to eq(true)

      expect(@request_setting.saturdayStartTime_element.visible?).to eq(true)
      expect(@request_setting.saturdayEndTime_element.visible?).to eq(true)

      expect(@request_setting.sundayStartTime_element.visible?).to eq(true)
      expect(@request_setting.sundayEndTime_element.visible?).to eq(true)

      @request_setting.monday_element.click
      @request_setting.tuesday_element.click
      @request_setting.wednesday_element.click
      @request_setting.thursday_element.click
      @request_setting.friday_element.click
      @request_setting.saturday_element.click
      @request_setting.sunday_element.click

      #start time and end time fields hidden
      expect(@request_setting.mondayStartTime_element.visible?).to eq(false)
      expect(@request_setting.mondayEndTime_element.visible?).to eq(false)

      expect(@request_setting.tuesdayStartTime_element.visible?).to eq(false)
      expect(@request_setting.tuesdayEndTime_element.visible?).to eq(false)

      expect(@request_setting.wednesdayStartTime_element.visible?).to eq(false)
      expect(@request_setting.wednesdayEndTime_element.visible?).to eq(false)

      expect(@request_setting.thursdayStartTime_element.visible?).to eq(false)
      expect(@request_setting.thursdayEndTime_element.visible?).to eq(false)

      expect(@request_setting.fridayStartTime_element.visible?).to eq(false)
      expect(@request_setting.fridayEndTime_element.visible?).to eq(false)

      expect(@request_setting.saturdayStartTime_element.visible?).to eq(false)
      expect(@request_setting.saturdayEndTime_element.visible?).to eq(false)

      expect(@request_setting.sundayStartTime_element.visible?).to eq(false)
      expect(@request_setting.sundayEndTime_element.visible?).to eq(false)
    end

    it "If start time/end time is not valued for a given row, display error message" do

      @request_setting.monday_element.click
      @request_setting.tuesday_element.click
      @request_setting.wednesday_element.click
      @request_setting.thursday_element.click
      @request_setting.friday_element.click
      @request_setting.saturday_element.click
      @request_setting.sunday_element.click

      @request_setting.bottomSave

      @error.errorSummaryHeader_element.when_visible(TIME_OUT_LIMIT)
      expect(@error.isErrorMsgDisplayed?("Monday Start Time is required")).to eq(true)
      expect(@error.isErrorMsgDisplayed?("Monday End Time is required")).to eq(true)
      expect(@error.isErrorMsgDisplayed?("Tuesday Start Time is required")).to eq(true)
      expect(@error.isErrorMsgDisplayed?("Tuesday End Time is required")).to eq(true)
      expect(@error.isErrorMsgDisplayed?("Wednesday Start Time is required")).to eq(true)
      expect(@error.isErrorMsgDisplayed?("Wednesday End Time is required")).to eq(true)
      expect(@error.isErrorMsgDisplayed?("Thursday Start Time is required")).to eq(true)
      expect(@error.isErrorMsgDisplayed?("Thursday End Time is required")).to eq(true)
      expect(@error.isErrorMsgDisplayed?("Friday Start Time is required")).to eq(true)
      expect(@error.isErrorMsgDisplayed?("Friday End Time is required")).to eq(true)
      expect(@error.isErrorMsgDisplayed?("Saturday Start Time is required")).to eq(true)
      expect(@error.isErrorMsgDisplayed?("Saturday End Time is required")).to eq(true)
      expect(@error.isErrorMsgDisplayed?("Sunday Start Time is required")).to eq(true)
      expect(@error.isErrorMsgDisplayed?("Sunday End Time is required")).to eq(true)
    end

    it "If start time is not before end time, display error:" do
      @request_setting.mondayStartTime = "13:30"
      @request_setting.mondayEndTime = "13:00"

      @request_setting.tuesdayStartTime = "21:30"
      @request_setting.tuesdayEndTime =  "17:30"

      @request_setting.wednesdayStartTime = "15:10"
      @request_setting.wednesdayEndTime = "05:23"

      @request_setting.thursdayStartTime = "19:00"
      @request_setting.thursdayEndTime = "15:00"

      @request_setting.fridayStartTime = "22:10"
      @request_setting.fridayEndTime = "14:45"

      @request_setting.saturdayStartTime = "19:30"
      @request_setting.saturdayEndTime = "12:30"

      @request_setting.sundayStartTime = "17:30"
      @request_setting.sundayEndTime = "16:00"

      @request_setting.bottomSave
      @error.errorSummaryHeader_element.when_visible(TIME_OUT_LIMIT)


      expect(@error.isErrorMsgDisplayed?("Monday Start time must be before End Time.")).to eq(true)
      expect(@error.isErrorMsgDisplayed?("Tuesday Start time must be before End Time.")).to eq(true)
      expect(@error.isErrorMsgDisplayed?("Wednesday Start time must be before End Time.")).to eq(true)
      expect(@error.isErrorMsgDisplayed?("Thursday Start time must be before End Time.")).to eq(true)
      expect(@error.isErrorMsgDisplayed?("Friday Start time must be before End Time.")).to eq(true)
      expect(@error.isErrorMsgDisplayed?("Saturday Start time must be before End Time.")).to eq(true)
      expect(@error.isErrorMsgDisplayed?("Sunday Start time must be before End Time.")).to eq(true)


      @request_setting.mondayStartTime = "13:30"
      @request_setting.mondayEndTime = "01:30 PM"

      @request_setting.tuesdayStartTime = "21:30"
      @request_setting.tuesdayEndTime =  "21:30"

      @request_setting.wednesdayStartTime = "09:10"
      @request_setting.wednesdayEndTime = "09:10"

      @request_setting.thursdayStartTime = "19:00"
      @request_setting.thursdayEndTime = "19:00"

      @request_setting.fridayStartTime = "22:10"
      @request_setting.fridayEndTime = "22:10"

      @request_setting.saturdayStartTime = "19:30"
      @request_setting.saturdayEndTime = "19:30"

      @request_setting.sundayStartTime = "17:30"
      @request_setting.sundayEndTime = "17:30"

      @request_setting.bottomSave
      @error.errorSummaryHeader_element.when_visible(TIME_OUT_LIMIT)

      expect(@error.isErrorMsgDisplayed?("Monday Start time must be before End Time.")).to eq(true)
      expect(@error.isErrorMsgDisplayed?("Tuesday Start time must be before End Time.")).to eq(true)
      expect(@error.isErrorMsgDisplayed?("Wednesday Start time must be before End Time.")).to eq(true)
      expect(@error.isErrorMsgDisplayed?("Thursday Start time must be before End Time.")).to eq(true)
      expect(@error.isErrorMsgDisplayed?("Friday Start time must be before End Time.")).to eq(true)
      expect(@error.isErrorMsgDisplayed?("Saturday Start time must be before End Time.")).to eq(true)

    end

    it "Save Request" do
      @request_setting.mondayStartTime = "08:30"
      @request_setting.mondayEndTime = "17:00"

      @request_setting.tuesdayStartTime = "09:30"
      @request_setting.tuesdayEndTime =  "17:30"

      @request_setting.wednesdayStartTime = "09:10"
      @request_setting.wednesdayEndTime = "16:23"

      @request_setting.thursdayStartTime = "07:00"
      @request_setting.thursdayEndTime = "15:00"

      @request_setting.fridayStartTime = "10:10"
      @request_setting.fridayEndTime = "14:45"

      @request_setting.saturdayStartTime = "07:30"
      @request_setting.saturdayEndTime = "12:30"

      @request_setting.sundayStartTime = "13:30"
      @request_setting.sundayEndTime = "16:00"

      saveAndConfirm

      #Retrieve mongo

      schedulingDaysArr = [["MONDAY", "true", "08:30", "17:00"], ["TUESDAY", "true", "09:30", "17:30"], ["WEDNESDAY", "true", "09:10", "16:23"],["THURSDAY", "true", "07:00", "15:00"],["FRIDAY", "true", "10:10", "14:45"], ["SATURDAY", "true", "07:30", "12:30"], ["SUNDAY", "true", "13:30", "16:00"]]
      verifyExpresscareDatainMongoDB("523A5", "2", "true",  "Express Care", schedulingDaysArr)
    end

    it "Update existing configuration" do
      #Uncheck Friday, Saturday, Sunday
      @request_setting.friday_element.scroll_into_view
      Watir::Wait.until {@request_setting.friday_element.visible?}
      sleep 2
      @request_setting.friday_element.click
      @common.wait_untill_elements_size_steadied(TIME_OUT_LIMIT)

      @request_setting.saturday_element.click
      @common.wait_untill_elements_size_steadied(TIME_OUT_LIMIT)

      @request_setting.sunday_element.click
      @common.wait_untill_elements_size_steadied(TIME_OUT_LIMIT)

      saveAndConfirm
      schedulingDaysArr = [["MONDAY", "true", "08:30", "17:00"], ["TUESDAY", "true", "09:30", "17:30"], ["WEDNESDAY", "true", "09:10", "16:23"],["THURSDAY", "true", "07:00", "15:00"],["FRIDAY", "false", "", ""], ["SATURDAY", "false", "", ""], ["SUNDAY", "false", "", ""]]
      verifyExpresscareDatainMongoDB("523A5", "2", "true",  "Express Care", schedulingDaysArr)


    end

    it "Update existing configuration to 'No'" do
      @common.wait_untill_elements_size_steadied(TIME_OUT_LIMIT)
      @request_setting.expressCareNotSupported_element.when_visible(TIME_OUT_LIMIT)

      sleep 3
      @request_setting.expressCareNotSupported_element.click
      @request_setting.expressCareNotSupported_element.fire_event('onblur')

      saveAndConfirm

      #Retrieve mongo
      schedulingDaysArr = [["MONDAY", "false", "", ""], ["TUESDAY", "false", "", ""], ["WEDNESDAY", "false", "", ""],["THURSDAY", "false", "", ""],["FRIDAY", "false", "", ""], ["SATURDAY", "false", "", ""], ["SUNDAY", "false", "", ""]]
      verifyExpresscareDatainMongoDB("523A5", "0", "false",  "Express Care", schedulingDaysArr)

    end

  end

  def verifyExpresscareDatainMongoDB(facilityId, requestLimit, supported,  typeOfCare, schedulingDaysArr)
    value = getCustomRequestSetting("requestEligibilityCriteria", facilityId, @db)
    expect(requestLimit).to eq(value['submittedRequestLimit'].to_s)
    expect(supported).to eq(value['supported'].to_s)
    expect(typeOfCare).to eq(value['typeOfCare'])

    schedulingDays =  value['schedulingDays']

    monday = schedulingDays[0]
    expect(schedulingDaysArr[0][0]).to eq(monday['day'].to_s)
    expect(schedulingDaysArr[0][1]).to eq(monday['canSchedule'].to_s)
    expect(schedulingDaysArr[0][2]).to eq(monday['startTime'].to_s)
    expect(schedulingDaysArr[0][3]).to eq(monday['endTime'].to_s)

    tuesday = schedulingDays[1]
    expect(schedulingDaysArr[1][0]).to eq(tuesday['day'].to_s)
    expect(schedulingDaysArr[1][1]).to eq(tuesday['canSchedule'].to_s)
    expect(schedulingDaysArr[1][2]).to eq(tuesday['startTime'].to_s)
    expect(schedulingDaysArr[1][3]).to eq(tuesday['endTime'].to_s)

    wednesday = schedulingDays[2]
    expect(schedulingDaysArr[2][0]).to eq(wednesday['day'].to_s)
    expect(schedulingDaysArr[2][1]).to eq(wednesday['canSchedule'].to_s)
    expect(schedulingDaysArr[2][2]).to eq(wednesday['startTime'].to_s)
    expect(schedulingDaysArr[2][3]).to eq(wednesday['endTime'].to_s)

    thursday = schedulingDays[3]
    expect(schedulingDaysArr[3][0]).to eq(thursday['day'].to_s)
    expect(schedulingDaysArr[3][1]).to eq(thursday['canSchedule'].to_s)
    expect(schedulingDaysArr[3][2]).to eq(thursday['startTime'].to_s)
    expect(schedulingDaysArr[3][3]).to eq(thursday['endTime'].to_s)

    friday = schedulingDays[4]
    expect(schedulingDaysArr[4][0]).to eq(friday['day'].to_s)
    expect(schedulingDaysArr[4][1]).to eq(friday['canSchedule'].to_s)
    expect(schedulingDaysArr[4][2]).to eq(friday['startTime'].to_s)
    expect(schedulingDaysArr[4][3]).to eq(friday['endTime'].to_s)

    saturday = schedulingDays[5]
    expect(schedulingDaysArr[5][0]).to eq(saturday['day'].to_s)
    expect(schedulingDaysArr[5][1]).to eq(saturday['canSchedule'].to_s)
    expect(schedulingDaysArr[5][2]).to eq(saturday['startTime'].to_s)
    expect(schedulingDaysArr[5][3]).to eq(saturday['endTime'].to_s)

    sunday = schedulingDays[6]
    expect(schedulingDaysArr[6][0]).to eq(sunday['day'].to_s)
    expect(schedulingDaysArr[6][1]).to eq(sunday['canSchedule'].to_s)
    expect(schedulingDaysArr[6][2]).to eq(sunday['startTime'].to_s)
    expect(schedulingDaysArr[6][3]).to eq(sunday['endTime'].to_s)

  end

  def compareContents(expected_content, actual_content)
    expected_content.each_with_index do |expectedScreenRow, i|
      expect(actual_content[i].strip).to include(expectedScreenRow.strip)
    end
  end

  def saveAndConfirm

    @request_setting.bottomSave_element.scroll_into_view
    @request_setting.bottomSave

    @modal.modalTitle_element.when_visible(TIME_OUT_LIMIT)
    #todo: need to remove Popup modal text
    expect(@modal.modalTitle).to eq("Popup modal\nConfirmation")
    expect(@modal.content).to eq("The Request settings have been saved.")

    expect(@modal.buttons_elements[0].text).to eq("OK")
    @modal.buttons_elements[0].click
    @common.waitWhileSpinnerPresent
  end

end






